const express = require("express");
const router = express.Router();
const addTeamLead = require("../controllers/teamlead/addTeamLead");
const getEmployeeStaticData = require("../controllers/getEmployeeStaticData");
const addLoginDetails = require("../controllers/addLoginDetails");
const checkUniqueFields = require("../controllers/checkUniqueFields");
const aggregateTeamLead = require("../controllers/teamlead/aggregateTeamLead");
const updateTeamLead = require("../controllers/teamlead/updateTeamLead");

//Get Static Data for dropdown
router.get("/getSD", getEmployeeStaticData);

//Register Team Lead
router.post("/addTL", checkUniqueFields, addTeamLead, addLoginDetails);

//update and save teamlead
router.put("/updateTL/:id", updateTeamLead);

//aggregate TL with Ch and executive
router.get("/getTL", aggregateTeamLead);

module.exports = router;  
