const express = require("express");
const user = express();

const bodyParser = require("body-parser");
const PopUpModel = require("../models/popup/popUpSchema");
const addPopupVal = require("../controllers/popup/popup")

user.use(bodyParser.urlencoded({ extended: true }));
user.get("/getpopup", async (req, resp) => {
  let data = await PopUpModel.find();
  console.log(data);
  resp.send(data);
});

// post popup data
user.post("/addpopupdata", addPopupVal, async (req, resp) => {
  new PopUpModel({
    id: req.gid,
    name: req.body.name,
    email: req.body.email,
    contact: req.body.contact,
    country: req.body.country,
    state: req.body.state,
    city: req.body.city,
    course: req.body.course,
    message: req.body.message,
  }).save();
  resp.send({ response: " Pop up Data added successfully" });
});

module.exports = user;
