const express = require("express");
const router = express();
const addEmployee = require("../controllers/addEmployee");
const checkUniqueFields = require("../controllers/checkUniqueFields");
const addLoginDetails = require('../controllers/addLoginDetails');
const fileUpload = require("../middleware/fileUpload");

router.post(
  "/addEmp",
  checkUniqueFields,
  fileUpload.fields([
    { name: "photo" },
    { name: "signature" },
    { name: "files", maxCount: 5 },
  ]),
  addEmployee,
  addLoginDetails
);
module.exports = router;