const express = require("express");
const router = express.Router();
const fileUpload = require("../middleware/fileUpload");
const addActivity = require("../controllers/lead/addActivity");
const { getUniveristy } = require("../controllers/manageUniveristy/univeristy");
const activityStaticData = require("../controllers/lead/activityStaticData");

//API for posting activity form data
router.post(
  "/add-activity",
  fileUpload.single("file"),
  addActivity,
  async function (req, res) {
    res.send({ res: "Activity Added Successfully" });
  }
);

//API for fetching dropdown data for activity form
router.get("/static-data", activityStaticData);

//API for fetching universities data for activity form from json file in database
router.get("/get-university", getUniveristy);

module.exports = router;
