var teamLeadRegister = require("../../models/teamlead/teamLeadRegister");
const sequenceSchema = require("../../models/generateId");
const { default: mongoose } = require("mongoose");
require("../../db/config");

const addTeamLead = async (req, res, next) => {
  let year = new Date().getFullYear();
  let genID = new mongoose.Types.ObjectId();

  const doc = await sequenceSchema.findOneAndUpdate(
    {},
    { $inc: { uniqueIdTL: 1 } },
    { new: true, upsert: true }
  );

  await new teamLeadRegister({
    empId: `PA/` + `TL/` + year + `/` + doc.uniqueIdTL,
    id: genID,
    centerHead: req.body.centerHead,
    firstName: req.body.firstName,
    lastName: req.body.lastName,
    email: req.body.email,
    password: req.body.password,
    phone: req.body.phone,
    DOB: req.body.DOB,
    dateOfInterview: req.body.dateOfInterview,
    dateOfJoining: req.body.dateOfJoining,
    dateOfResignation: req.body.dateOfResignation,
    trainingDateFrom: req.body.trainingDateFrom,
    trainingDateTo: req.body.trainingDateTo,
    mobileCharge: req.body.mobileCharge,
    pTax: req.body.pTax,
    basicSalary: req.body.basicSalary,
    hra: req.body.hra,
    conveyance: req.body.conveyance,
    allowances: req.body.allowances,
    offeredSalary: req.body.offeredSalary,
    jobLocation: req.body.jobLocation,
    sharePercent: req.body.sharePercent,
    post: req.body.post,
    department: req.body.department,
    unit: req.body.unit,
    status: req.body.status,
    // createdAt: 
  }).save();
  req.sid = genID;
  next();
};

module.exports = addTeamLead;
