
const Model = require("../../models/manageUniveristy/university");


const getUniveristy = async function (req, res, next) {
  try {
    const universities = await Model.find();
    res.json(universities);
  } catch (err) {
    console.error(err);
    res.status(500).send('Server error');
  }
}

const getUniveristyById = async function (req, res, next) {
  try {
    const university = await Model.findById(req.params.id);
    res.json(university);
  } catch (err) {
    console.error(err);
    res.status(500).send('Server error');
  }
}

const postUniversity = async function (req, res, next) {
  const { universityName, courseDetails, universityStatus } = req.body;

  const uniqueId = await Model.find().limit(1).sort({ $natural: -1 })


  const uId = uniqueId.length ? (parseInt(uniqueId[0]?.uId) + 1).toString() : String(1)
  const department = [];
  const course = [];
  const specialization = [];
  const courseCategory = [];
  const mode = [];
  const noOfSemsOrNoOfYears = [];
  const eligibility = [];
  const tuitionFee = [];
  const otherFee = [];
  const totalFee = [];

  for (let i = 0; i < courseDetails.length; i++) {
    const obj = courseDetails[i];

    if (department.filter(item => item.name === obj.department).length === 0) {
      department.push({ dId: department.length + 1, name: obj.department })
      course.push({ cId: course.length + 1, name: obj.course, dId: department.length })
      specialization.push({ sId: specialization.length + 1, name: obj.specialization, cId: course.length, status: "Active" })
      courseCategory.push({ ccId: courseCategory.length + 1, type: obj.courseCategory ? obj.courseCategory : courseCategory[courseCategory.length - 1].type, sId: specialization.length })
      mode.push({ mId: mode.length + 1, type: obj.mode ? obj.mode : mode[mode.length - 1].type, sId: specialization.length })
      noOfSemsOrNoOfYears.push({ nSYId: noOfSemsOrNoOfYears.length + 1, value: obj.noOfSemsOrNoOfYears, sId: specialization.length })
      eligibility.push({ eId: eligibility.length + 1, details: obj.eligibility, sId: specialization.length })
      tuitionFee.push({ tuId: tuitionFee.length + 1, value: obj.tuitionFee, sId: specialization.length })
      otherFee.push({ oId: otherFee.length + 1, value: obj.otherFee, sId: specialization.length })
      totalFee.push({ tfId: totalFee.length + 1, value: obj.totalFee, sId: specialization.length })
    }
    else {
      if (course.filter(item => item.name === obj.course).length === 0) {
        course.push({ cId: course.length + 1, name: obj.course, dId: department.length })
        specialization.push({ sId: specialization.length + 1, name: obj.specialization, cId: course.length, status: "Active" })
        courseCategory.push({ ccId: courseCategory.length + 1, type: obj.courseCategory ? obj.courseCategory : courseCategory[courseCategory.length - 1].type, sId: specialization.length })
        mode.push({ mId: mode.length + 1, type: obj.mode ? obj.mode : mode[mode.length - 1].type, sId: specialization.length })
        noOfSemsOrNoOfYears.push({ nSYId: noOfSemsOrNoOfYears.length + 1, value: obj.noOfSemsOrNoOfYears, sId: specialization.length })
        eligibility.push({ eId: eligibility.length + 1, details: obj.eligibility, sId: specialization.length })
        tuitionFee.push({ tuId: tuitionFee.length + 1, value: obj.tuitionFee, sId: specialization.length })
        otherFee.push({ oId: otherFee.length + 1, value: obj.otherFee, sId: specialization.length })
        totalFee.push({ tfId: totalFee.length + 1, value: obj.totalFee, sId: specialization.length })

      } else {
        specialization.push({ sId: specialization.length + 1, name: obj.specialization, cId: course.length, status: "Active" })
        courseCategory.push({ ccId: courseCategory.length + 1, type: obj.courseCategory ? obj.courseCategory : courseCategory[courseCategory.length - 1].type, sId: specialization.length })
        mode.push({ mId: mode.length + 1, type: obj.mode ? obj.mode : mode[mode.length - 1].type, sId: specialization.length })
        noOfSemsOrNoOfYears.push({ nSYId: noOfSemsOrNoOfYears.length + 1, value: obj.noOfSemsOrNoOfYears, sId: specialization.length })
        eligibility.push({ eId: eligibility.length + 1, details: obj.eligibility, sId: specialization.length })
        tuitionFee.push({ tuId: tuitionFee.length + 1, value: obj.tuitionFee, sId: specialization.length })
        otherFee.push({ oId: otherFee.length + 1, value: obj.otherFee, sId: specialization.length })
        totalFee.push({ tfId: totalFee.length + 1, value: obj.totalFee, sId: specialization.length })
      }
    }
  }

  const temp = {
    uId,
    universityName,
    universityStatus,
    department,
    course,
    specialization,
    courseCategory,
    mode,
    tuitionFee,
    otherFee,
    totalFee,
    noOfSemsOrNoOfYears,
    eligibility
  }


  const doc = new Model(temp)
  const result = doc.save();
  result.then(response => res.send(response))

  // const dateOptions = { timeZone: "Asia/Kolkata", hour12: true };
  // const formattedTimestamp = new Date().toLocaleString("en-US", {
  //   ...dateOptions,
  //   day: "numeric",
  //   month: "numeric",
  //   year: "numeric",
  //   hour: "numeric",
  //   minute: "numeric",
  //   second: "numeric",
  //   hour12: true
  // });

  // const university = new University({
  //   university: universityData.universityName.university,
  //   SemesterData: [],
  //   YearlyData: [],
  //   universityStatus: universityData.universityStatus.universityStatusinput,
  //   timestamp: universityData.timestamp,
  //   formattedTimestamp: formattedTimestamp,
  //   updatedTimestamp: "Not Updated", 
  // });





  // // Save the University document to the database
  // try {
  //   const data = new University(req.body)
  //   const result = await data.save();
  //   res.send(result);

  // } catch (err) {
  //   console.error(err);
  //   res.status(500).send("Error saving university data to the database");
  // }
};


// app.put("/api/universities/:id", 

const updateUniversity = async function (req, res) {
  const universityData = req.body;
  const universityId = req.params.id;
  const university = await University.findById(universityId);

  const dateOptions = { timeZone: "Asia/Kolkata", hour12: true };
  const updatedTimestamp = new Date().toLocaleString("en-US", {
    ...dateOptions,
    day: "numeric",
    month: "numeric",
    year: "numeric",
    hour: "numeric",
    minute: "numeric",
    second: "numeric",
    hour12: true
  });

  if (!university) {
    return res.status(404).send("University not found");
  } else {
    try {
      const result = await University.findOneAndUpdate({ _id: universityId }, {
        $set: {
          university: universityData.university,
          SemesterData: universityData.SemesterData,
          YearlyData: universityData.YearlyData,
          universityStatus: universityData.status,
          newtimestamp: universityData.newtimestamp,
          updatedTimestamp: updatedTimestamp
        }
      })
      res.send(result);
    } catch (err) {
      console.error(err);
      res.status(500).send("Error updating university data in the database");
    }

  }


};

const deleteUniveristy = async (req, res) => {
  try {
    const university = await Model.findByIdAndRemove(req.params.id);
    if (!university) {
      return res.status(404).send();
    }
    res.send(university);
  } catch (error) {
    res.status(500).send(error);
  }
}




module.exports = { postUniversity, updateUniversity, getUniveristy, getUniveristyById ,deleteUniveristy }