const centerHeadRegister = require("../../models/centerhead/centerHeadRegister");

const getExecutiveAggregation = async (req, res) => {
  let aggregatedData = await centerHeadRegister.aggregate([
    {
      $lookup: {
        from: "TeamLead",
        as: "teamleads",
        let: { chId: "$chUniqueId" },
        pipeline: [
          {
            $match: {
              $expr: { $and: [{ $eq: ["$centerHead", "$$chId"] }] },
            },
          },
        ],
      },
    },
  ]);
  res.send(aggregatedData);
};

module.exports = getExecutiveAggregation;


