var ExecutiveSchema = require("../../models/executive/executiveRegister");
var counterSchema = require("../../models/generateId");
const { default: mongoose } = require("mongoose");
const moment = require('moment');
require("../../db/config");

const addExecutive = async (req, res, next) => {
  let currentDate = new Date();
  let year = currentDate.getFullYear();
  let createdAt = moment(currentDate).format("YYYY-MM-DD HH:mm:ss a");
  const doc = await counterSchema.findOneAndUpdate(
    {},
    { $inc: { uniqueIdEX: 1 } },
    { new: true, upsert: true }
  );
  await new ExecutiveSchema({
    empId: `PA/` + `TL/` + year + `/` + doc.uniqueIdEX,
    exUniqueId: new mongoose.Types.ObjectId(),
    createdAt: createdAt,
    centerHead: req.body.centerHead,
    teamLead: req.body.teamLead,
    firstName: req.body.firstName,
    lastName: req.body.lastName,
    email: req.body.email,
    password: req.body.password,
    phone: req.body.phone,
    DOB: req.body.DOB,
    dateOfInterview: req.body.dateOfInterview,
    dateOfJoining: req.body.dateOfJoining,
    dateOfResignation: req.body.dateOfResignation,
    trainingDateFrom: req.body.trainingDateFrom,
    trainingDateTo: req.body.trainingDateTo,
    mobileCharge: req.body.mobileCharge,
    pTax: req.body.pTax,
    basicSalary: req.body.basicSalary,
    hra: req.body.hra,
    conveyance: req.body.conveyance,
    allowances: req.body.allowances,
    offeredSalary: req.body.offeredSalary,
    jobLocation: req.body.jobLocation,
    sharePercent: req.body.sharePercent,
    post: req.body.post,
    department: req.body.department,
    unit: req.body.unit,
    status: req.body.status,
  }).save();
  next();
};

module.exports = addExecutive;
