var centerHeadRegister = require("../../models/centerhead/centerHeadRegister");
var sequenceSchema = require("../../models/generateId");
require("../../db/config");
var mongoose = require("mongoose");
const moment = require('moment');

const centerHead = async (req, res, next) => {
  let currentDate = await new Date();
  let year = currentDate.getFullYear();
  let createdAt=moment(currentDate).format('DD-MM-YYYY HH:mm:ss a')
  let genID = new mongoose.Types.ObjectId();
  const doc = await sequenceSchema.findOneAndUpdate(
    {},
    { $inc: { uniqueIdCH: 1 } },
    { new: true, upsert: true }
  );
  new centerHeadRegister({
    empId: `PA/` + `CH/` + year + `/` + doc.uniqueIdCH,
    chUniqueId: genID,
    createdAt:createdAt,
    firstName: req.body.firstName,
    lastName: req.body.lastName,
    email: req.body.email,
    password: req.body.password,
    phone: req.body.phone,
    DOB: req.body.DOB,
    post: req.body.post,
    department: req.body.department,
    unit: req.body.unit,
    mobileCharge: req.body.mobileCharge,
    pTax: req.body.pTax,
    basicSalary: req.body.basicSalary,
    hra: req.body.hra,
    conveyance: req.body.conveyance,
    allowances: req.body.allowances,
    offeredSalary: req.body.offeredSalary,
    jobLocation: req.body.jobLocation,
    sharePercent: req.body.sharePercent,
    status: req.body.status,
  }).save();
  req.sid = genID ;
  next();
};

module.exports = centerHead;
