var createError = require("http-errors");
var express = require("express");
var path = require("path");
var cookieParser = require("cookie-parser");
var logger = require("morgan");
var app = express();
require("./db/config");

var leadRouter = require("./routes/leadRoute");
var PopUpRoute = require("./routes/popupRoute");
var centerHeadRouter = require("./routes/centerHead");
var activityRouter = require("./routes/activity");
var masterDataRouter = require("./routes/masterDataRoutes");
var aggregateDataRouter = require("./routes/aggregateDataRouter");
var teamLeadRouter = require("./routes/teamLead");
var executiveRouter = require("./routes/executive");
var employeeRouter = require("./routes/employee");
var univeristyRouter = require('./routes/university')
var addJobRouter = require("./routes/managejob");
var profileRouter = require("./routes/profile");  
var settingRouter = require("./routes/SettingRoute");
var commissionRouter = require("./routes/manageCommission");
var newRegistrationRouter = require("./routes/newRegistration");
var loginRouter = require("./routes/login"); 

// view engine setup
app.set("views", path.join(__dirname, "views"));
app.set("view engine", "pug");


app.use(logger("dev"));
app.use(logger("dev"));
app.use(express.json());
app.use(express.urlencoded({ extended: false }));
app.use(cookieParser());
app.use(express.static(path.join(__dirname, "public")));


// cors setup
const cors = require("cors");
const corsOptions = {
  origin: "*",
  credentials: true, //access-control-allow-credentials:true
  optionSuccessStatus: 200
};


app.use(cors(corsOptions));
app.use("/lead", leadRouter);
app.use("/popUp", PopUpRoute);
app.use("/TL", teamLeadRouter);
app.use("/EX", executiveRouter);
app.use("/emp", employeeRouter);
app.use("/CH", centerHeadRouter);
app.use("/activity", activityRouter);
app.use("/master", masterDataRouter);
app.use("/aggregate", aggregateDataRouter);
app.use("/TL", teamLeadRouter);
app.use("/EX", executiveRouter);
app.use("/emp", employeeRouter);
app.use("/university", univeristyRouter);
app.use("/addJob", addJobRouter);
app.use("/profile", profileRouter);
app.use("/setting", settingRouter);
app.use("/commission", commissionRouter);
app.use("/registration", newRegistrationRouter);
app.use("/login", loginRouter);

// catch 404 and forward to error handler
app.use(function (req, res, next) {
  next(createError(404));
});

// error handler
app.use(function (err, req, res, next) {
  // set locals, only providing error in development
  res.locals.message = err.message;
  res.locals.error = req.app.get("env") === "development" ? err : {};

  // render the error page
  res.status(err.status || 500);
  res.render("error");
});

module.exports = app;
