const express = require("express");
const user = express();

const multer = require("multer");
const path = require("path");
const bodyParser = require("body-parser");
const importUser = require("../controllers/lead/uploadfileController");
const Lead = require("../models/lead/LeadSchema");
//  use filevalidation middleware for adding size and type validation on file
const filevalidation = require("../middleware/fileValidation");
// use addleadval middleware for adding unique id
const addLeadVal = require("../controllers/lead/leadData");

user.use(bodyParser.urlencoded({ extended: true }));

// storage for upload file
var storage = multer.diskStorage({
  destination: (req, file, cb) => {
    cb(null, "./uploads");
  },

  filename: (req, file, cb) => {
    cb(null, file.originalname);
  },
});

var upload = multer({ storage: storage });
// upload file route without any validation
user.post("/uploadcsv", upload.single("file"), importUser, addLeadVal);
// user.post("/uploadcsv",upload.single("file"), (req,res)=>{
//   console.log(req.file)
//   res.send({mess:"hi"})
// });
// upload file route with size validation
user.post(
  "/up",
  upload.single("file"),
  filevalidation.validateSize,
  importUser
);
// upload file route with type  validation
user.post(
  "/uptype",
  upload.single("file"),
  filevalidation.validateType,
  importUser
);

// write for trying without email and contact validation
// user.post("/lead", async (req, resp) => {
//   let data = await Lead(req.body);
//   let res = await data.save();
//   console.log(res);
//   resp.send(res);
// });

// get api
// user.get("/getlead", async (req, resp) => {
//   let data = await Lead.find();
//   console.log(data);
//   resp.send(data);
// });

user.get("/getlead",async(req,resp)=>{
  let data=await Lead.find();
  console.log(data);
  resp.send(data);
})

// post lead
user.post("/addLead", addLeadVal, async (req, resp) => {
  new Lead({
    id: req.gid,
    fname: req.body.fname,
    lname: req.body.lname,
    email: req.body.email,
    contact: req.body.contact,
    experience: req.body.experience,
    country: req.body.country,
    state: req.body.state,
    city: req.body.city,
    qualification: req.body.qualification,
    passingYear: req.body.passingYear,
    refBy: req.body.refBy,
    refName: req.body.refName,
  }).save();
  resp.send({ response: "Data added successfully" });
});

module.exports = user;
