const express = require("express");
const router = express.Router();
const getEmployeeStaticData = require('../controllers/getEmployeeStaticData');
const addExecutive = require("../controllers/executive/addExecutive");
const checkUniqueFields = require("../controllers/checkUniqueFields");
const addLoginDetails = require("../controllers/addLoginDetails");
const updateExecutive = require("../controllers/executive/updateExecutive");
const aggregateExecutive = require("../controllers/executive/aggregateExecutive");

//Get Static Data for dropdown
router.get("/getSD", getEmployeeStaticData);

//Register Team Lead
router.post("/addEX", checkUniqueFields, addExecutive, addLoginDetails);

//update and save executive
router.put("/updateEX/:id", updateExecutive);

//aggregate EX with CH and TL
router.get("/getEX", aggregateExecutive);

module.exports = router;