var express = require("express");
var router = express.Router();
var addCenterHead = require("../controllers/centerhead/addCenterHead");
var checkUniqueFields = require("../controllers/checkUniqueFields");
var addLoginDetails = require("../controllers/addLoginDetails");
var aggregateCenterHead = require("../controllers/centerhead/aggregateCenterHead");
var updateCenterHead = require("../controllers/centerhead/updateCenterHead");
var addEmployee = require('../controllers/addEmployee');

//API to aggregate data to show in table of manange center head
router.get("/getCH", aggregateCenterHead);

//API to register center head
router.post("/addCH", checkUniqueFields, addCenterHead, addLoginDetails, addEmployee);

//API for editing center head
router.put("/updateCH/:id", updateCenterHead);

module.exports = router;
