const mongoose = require("mongoose");
mongoose.pluralize(null);
require("../../db/config");

const univeristySchema = new mongoose.Schema({
  uId: { type: Number, required: true },
  universityName: { type: String, required: true },

  department: [
    {
      dId: { type: Number, required: true },
      name: { type: String, required: true },
    },
  ],

  course: [
    {
      cId: { type: Number, required: true },
      name: { type: String, required: true },
      dId: { type: Number, required: true },
    },
  ],

  specialization: [
    {
      sId: { type: Number, required: true },
      name: { type: String, required: true },
      cId: { type: Number, required: true },
      status: { type: String, required: true },
    },
  ],

  courseCategory: [
    {
      ccId: { type: Number, required: true },
      type: { type: String, required: true },
      sId: { type: Number, required: true },
    },
  ],

  mode: [
    {
      mId: { type: Number, required: true },
      type: { type: String, required: true },
      sId: { type: Number, required: true },
    },
  ],

  noOfSemsOrNoOfYears: [
    {
      nSYId: { type: Number, required: true },
      value: { type: String, required: true },
      sId: { type: Number, required: true },
    },
  ],

  eligibility: [
    {
      eId: { type: Number, required: true },
      details: { type: String, required: true },
      sId: { type: Number, required: true },
    },
  ],

  tuitionFee: [
    {
      tuId: { type: Number, required: true },
      value: { type: String, required: true },
      sId: { type: Number, required: true },
    },
  ],

  otherFee: [
    {
      oId: { type: Number, required: true },
      value: { type: String, required: true },
      sId: { type: Number, required: true },
    },
  ],

  totalFee: [
    {
      tfId: { type: Number, required: true },
      value: { type: String, required: true },
      sId: { type: Number, required: true },
    },
  ],

  universityStatus: { type: String, required: true },
});

module.exports = mongoose.model("University", univeristySchema);
