const teamLeadRegister = require("../../models/teamlead/teamLeadRegister");

const aggregateTeamLead = async (req, res, next) => {
  
  let data = await teamLeadRegister.aggregate([
    {
      $lookup: {
        from: "CenterHead",
        as: "centerheads",
        let: { tlId: "$centerHead" },
        pipeline: [
          {
            $match: {
              $expr: { $and: [{ $eq: ["$chUniqueId", "$$tlId"] }] },
            },
          },
        ],
      },
    },
    {
      $lookup: {
        from: "Executive",
        as: "executives",
        let: { asId: "$tlUniqueId" },
        pipeline: [
          {
            $match: {
              $expr: { $and: [{ $eq: ["$teamLead", "$$asId"] }] },
            },
          },
        ],
      },
    },
  ]);
  res.send(data);
};
module.exports = aggregateTeamLead;
