var csvtojson = require('csvtojson');
var Model = require('../../models/manageUniveristy/university')


const importCSV = async (req, res) => {

    const uniqueId = await Model.find().limit(1).sort({$natural:-1}) 

    csvtojson().fromFile(req.file.path).then((jsonObj) => {

        const uId = uniqueId.length ? (parseInt(uniqueId[0]?.uId) + 1).toString() : String(1) ;

        let universityName;
        const department = [];
        const course = [];
        const specialization = [];
        const courseCategory = [];
        const mode = [];
        const noOfSemsOrNoOfYears = [];
        const eligibility = [];
        const tuitionFee = [];
        const otherFee = [];
        const totalFee = [];
        const universityStatus = "Active"

        for (var i = 0; i < jsonObj.length; i++) {
            const obj = jsonObj[i];

            if (obj['Select University']) {

                universityName = obj['Select University'];
                department.push({ dId: department.length + 1, name: obj['Select Faculty/Department/School'] })
                course.push({ cId: course.length + 1, name: obj['Select Course/Program Name'], dId: department.length })
                specialization.push({ sId: specialization.length + 1, name: obj['Select Specialization Name'], cId: course.length,status:"Active" })
                courseCategory.push({ccId:courseCategory.length+1,type:obj['Select Course Category'] ? obj['Select Course Category'] : courseCategory[courseCategory.length-1].type,sId: specialization.length})
                mode.push({ mId: mode.length + 1, type: obj['Select Mode'] ? obj['Select Mode'] : mode[mode.length-1].type , sId: specialization.length })
                noOfSemsOrNoOfYears.push({ nSYId: noOfSemsOrNoOfYears.length + 1, value: obj['Number Year Or Sem'], sId: specialization.length })
                eligibility.push({eId:eligibility.length+1,details:obj['Eligibility'],sId: specialization.length})
                tuitionFee.push({ tuId: tuitionFee.length + 1, value: obj['Tution Fee Per Year'], sId: specialization.length })
                otherFee.push({oId:otherFee.length + 1, value:obj['Other Fee'], sId: specialization.length})
                totalFee.push({tfId:totalFee.length + 1, value:obj['Total Fee'], sId: specialization.length})


            } else if (obj['Select Faculty/Department/School']) {

                department.push({ dId: department.length + 1, name: obj['Select Faculty/Department/School'] })
                course.push({ cId: course.length + 1, name: obj['Select Course/Program Name'], dId: department.length })
                specialization.push({ sId: specialization.length + 1, name: obj['Select Specialization Name'], cId: course.length, status:"Active" })
                courseCategory.push({ccId:courseCategory.length+1,type:obj['Select Course Category'] ? obj['Select Course Category'] : courseCategory[courseCategory.length-1].type,sId: specialization.length})
                mode.push({ mId: mode.length + 1, type: obj['Select Mode'] ? obj['Select Mode'] : mode[mode.length-1].type , sId: specialization.length })
                noOfSemsOrNoOfYears.push({ nSYId: noOfSemsOrNoOfYears.length + 1, value: obj['Number Year Or Sem'], sId: specialization.length })
                eligibility.push({eId:eligibility.length+1,details:obj['Eligibility'],sId: specialization.length})
                tuitionFee.push({ tuId: tuitionFee.length + 1, value: obj['Tution Fee Per Year'], sId: specialization.length })
                otherFee.push({oId:otherFee.length + 1, value:obj['Other Fee'], sId: specialization.length})
                totalFee.push({tfId:totalFee.length + 1, value:obj['Total Fee'], sId: specialization.length})

            } else if (obj['Select Course/Program Name']) {


                course.push({ cId: course.length + 1, name: obj['Select Course/Program Name'], dId: department.length })
                specialization.push({ sId: specialization.length + 1, name: obj['Select Specialization Name'], cId: course.length,status:"Active" })
                courseCategory.push({ccId:courseCategory.length+1,type:obj['Select Course Category'] ? obj['Select Course Category'] : courseCategory[courseCategory.length-1].type,sId: specialization.length})
                mode.push({ mId: mode.length + 1, type: obj['Select Mode'] ? obj['Select Mode'] : mode[mode.length-1].type , sId: specialization.length })
                noOfSemsOrNoOfYears.push({ nSYId: noOfSemsOrNoOfYears.length + 1, value: obj['Number Year Or Sem'], sId: specialization.length })
                eligibility.push({eId:eligibility.length+1,details:obj['Eligibility'],sId: specialization.length})
                tuitionFee.push({ tuId: tuitionFee.length + 1, value: obj['Tution Fee Per Year'], sId: specialization.length })
                otherFee.push({oId:otherFee.length + 1, value:obj['Other Fee'], sId: specialization.length})
                totalFee.push({tfId:totalFee.length + 1, value:obj['Total Fee'], sId: specialization.length})

            } else if (obj['Select Specialization Name']) {

                specialization.push({ sId: specialization.length + 1, name: obj['Select Specialization Name'], cId: course.length ,status:"Active"})
                courseCategory.push({ccId:courseCategory.length+1,type:obj['Select Course Category'] ? obj['Select Course Category'] : courseCategory[courseCategory.length-1].type,sId: specialization.length})
                mode.push({ mId: mode.length + 1, type: obj['Select Mode'] ? obj['Select Mode'] : mode[mode.length-1].type , sId: specialization.length })
                noOfSemsOrNoOfYears.push({ nSYId: noOfSemsOrNoOfYears.length + 1, value: obj['Number Year Or Sem'], sId: specialization.length })
                eligibility.push({eId:eligibility.length+1,details:obj['Eligibility'],sId: specialization.length})
                tuitionFee.push({ tuId: tuitionFee.length + 1, value: obj['Tution Fee Per Year'], sId: specialization.length })
                otherFee.push({oId:otherFee.length + 1, value:obj['Other Fee'], sId: specialization.length})
                totalFee.push({tfId:totalFee.length + 1, value:obj['Total Fee'], sId: specialization.length})

            } 


        }

        return {
            uId,
            universityName,
            department,
            course,
            specialization,
            courseCategory,
            mode,
            tuitionFee,
            otherFee,
            totalFee,
            noOfSemsOrNoOfYears,
            // eligibility,
            universityStatus
        }

    }).then(data => {

        const doc = new Model(data)
        const result = doc.save();
        result.then(response => res.send(response)).then(dat => console.log(dat))

        // res.send(data);
    })

    // res.send({id:doc[0].uId})
}

module.exports = importCSV;