const executiveRegister = require("../../models/executive/executiveRegister");

const aggregateExecutive = async (req, res, next) => {
  let data = await executiveRegister.aggregate([
    {
      $lookup: {
        from: "CenterHead",
        as: "centerHeadData",
        let: { id: "$centerHead" },
        pipeline: [
          {
            $match: {
              $expr: { $and: [{ $eq: ["$chUniqueId", "$$id"] }] },
            },
          },
        ],
      },
    },
    {
      $lookup: {
        from: "TeamLead",
        as: "teamLeadData",
        let: { id: "$teamLead" },
        pipeline: [
          {
            $match: {
              $expr: { $and: [{ $eq: ["$tlUniqueId", "$$id"] }] },
            },
          },
        ],
      },
    },
  ]);
  res.send(data);
};
module.exports = aggregateExecutive;
