const centerHeadRegister = require("../../models/centerhead/centerHeadRegister");

const aggregateCenterHead = async (req, res, next) => {
  let data = await centerHeadRegister.aggregate([
    {
      $lookup: {
        from: "TeamLead",
        as: "teamleads",
        let: { chId: "$chUniqueId" },
        pipeline: [
          {
            $match: {
              $expr: { $and: [{ $eq: ["$centerHead", "$$chId"] }] },
            },
          },
          {
            $lookup: {
              from: "Executive",
              as: "executives",
              let: { asId: "$tlUniqueId" },
              pipeline: [
                {
                  $match: {
                    $expr: { $and: [{ $eq: ["$teamLead", "$$asId"] }] },
                  },
                },
              ],
            },
          },
        ],
      },
    },
  ]);
  res.send(data);
};
module.exports = aggregateCenterHead;
