const employeeSchema = require("../models/employeeSchema");

const addEmployee = async (req, res, next) => {
  const photo = req.files["photo"][0];
  const signature = req.files["signature"][0];
  const photoName = photo.originalname;
  const photoPath = photo.path;
  const signName = signature.originalname;
  const signPath = signature.path;

  const files = req.files.files.map((file) => ({
    name: file.originalname,
    path: file.path,
  }));

  await new employeeSchema({
    photo: {
      name: photoName,
      path: photoPath,
    },
    signature: {
      name: signName,
      path: signPath,
    },
    fileInputs: files,
    fname: req.body.fname,
    lname: req.body.lname,
    fatherName: req.body.fatherName,
    dob: req.body.dob,
    nationality: req.body.nationality,
    maritalStatus: req.body.maritalStatus,
    addressp: req.body.addressp,
    addressc: req.body.addressc,
    contact: req.body.contact,
    phoneNo: req.body.phoneNo,
    email: req.body.email,
    skills: req.body.skills,
    hobbies: req.body.hobbies,
    education: req.body.educationList,
    experience: req.body.experience,
    Language: req.body.Language,
  }).save();
  next();
};

module.exports = addEmployee;

module.exports = addEmployee;
